import { Component, OnInit } from '@angular/core';
import { DataAccessService } from 'src/app/data-access.service';
import { DatePipe } from '@angular/common';
declare let alertify;

@Component({
  selector: 'app-new',
  templateUrl: './new.component.html',
  styleUrls: ['./new.component.css']
})
export class NewComponent implements OnInit {

  department;
  departments;
  transports;
  isPickup = false;
  isVehicle = false;
  materials;
  batches;
  material_type;
  material_name;
  qty;
  ar_no='';
  grn_no='';
  m_name='';
  lists=[];
  units;
  form;


  constructor(private service: DataAccessService) { 
    // this.from_date = this.datePipe.transform(Date.now(), 'yyyy-MM-01');
    // this.to_date = this.datePipe.transform(Date.now(), 'yyyy-MM-dd');
  }

  ngOnInit(): void {
    // this.getMaterialOutDetails();
    this.getDepartments();

  }

  getTransportVal(val) {
    if (val === 'By Transport') {
      this.isPickup = false;
      this.isVehicle = true;
    } else if (val === 'By Courier') {
      this.isVehicle = false;
      this.isPickup = true;
    }
  }

  number(value){
    if (isNaN(value)){
      alertify.error('Number 10 digit Only');
      return false;
    }
  }

  getMaterials(value) {
    this.service.get('store/outward.php?type=getMaterials&material_subtype='+value).subscribe(response => {
      this.materials = response;
    });
  }

  getBatch(index){
    this.batches = this.materials[index-1]['grns'];
    // this.material_code = this.materials[index-1]['product_code'];
  
  }
  setName(val){
    this.m_name = this.materials[val-1].material_name;
  }

getQty(val){
  console.log(this.batches[val-1]);
  this.qty = this.batches[val-1]['qty'];
  this.ar_no = this.batches[val-1]['ar_no'];
  this.grn_no = this.batches[val-1]['grn_no'];
} 

  addmaterial(data){
    let temp=data.value;
    temp['material_name']=this.m_name;
    this.lists.push(temp);
    // temp['material_name']=this.batches['material_name'];
    data.reset();
  }

  // getMaterialOutDetails() {
  //   this.service.get('store/outward.php?type=getOutwordLog&from_date=' + this.from_date + '&to_date=' + this.to_date+'&department_name='+ this.department).subscribe(response => {
  //  this.results = response;
  //   });
  // }
  
  saveoutward(data) {
    if (!data?.valid) {
      alertify.error('All fields are required');
      return;
    }
    let temp=data.value;
    temp['materials']=this.lists;
    this.service.post('store/outward.php?type=saveMaterialOutForm', JSON.stringify(temp))
    .subscribe(response => {
      if (response['status'] === 'success') {
       
        data.resetForm();
        // this.getMaterialOutDetails();
        alertify.success("save successfully");
      } else {
        alertify.error('Please Try Again');
      }
      },
    (error: Response) => {
      if (error.status === 400) {
        alertify.error('An error has occurred.');
      } else {
        alertify.error('An error occured');
      }
    });
    this.lists=[];
  }
  getDepartments() {
    this.service.get('hr/employee.php?type=get_department_by_designation')
      .subscribe(response => {
        this.departments = response;
      });
  }
}
